%               Hochschule Hamm-Lippstadt                       *
%****************************************************************
% Modul : System Design Engineering                             *
%                                                               *
% Datum : 21-06-2020                                            *
%                                                               *
% Funktion : Integrationstest                                   *
%                                                               *
% Implementation : MATLAB R2020a                                *
%                                                               *                                                             
% Author : Dominik Hermelingmeier & Isaac Mpidi Bita            *
%                                                               *                                                              
%****************************************************************
%% MATLAB Bereinigen
close all; clear; clc; 

%% Parameter initalisierung
%-----------------------------------------------------------
%% Reifen
%-----------------------------------------------------------
% Referenzmodell
c_v             = 1.2E5;    %[N/rad]
c_h             = 2.5E5;    %[N/rad]

% Zu testende Modell
ch = c_h; 
cv = c_v;

%-----------------------------------------------------------
%% Laengen
%-----------------------------------------------------------
% Referenzmodell
l_v             = 1.45;     %[m]
l               = 2.8;      %[m]
l_h             = l - l_v;

% Zu testende Modell
lh = l_h; 
lv = l_v;

%-----------------------------------------------------------
%% Massen
%-----------------------------------------------------------
% Referenzmodell
m               = 1978;     %[kg]
J_zz            = 3255.86;  %[kg*m^2]

% Zu testende Modell
Jzz = J_zz; 
%-----------------------------------------------------------
%% Sollgroessen
%-----------------------------------------------------------
% Geschwindigkeit
v               = 50;       %[m/s] immer groesser Null!!


%-----------------------------------------------------------
%% Matrizen für das Zustandsraummodell zusammensetzen
%-----------------------------------------------------------
A_11 = (-l_h^2 * c_h + l_v^2 * c_v) / J_zz / v;
A_12 = (l_h * c_h - l_v * c_v) / J_zz;
A_21 = (c_h * l_h - c_v * l_v - v^2 * m) / v^2 / m;
A_22 = -(c_v + c_h) / v / m;
ESM_A = [A_11, A_12; A_21, A_22];

B_11 = l_v * c_v / J_zz;
B_12 = -l_h * c_h / J_zz;
B_21 = c_v / v / m;
B_22 = -c_h / v / m;
ESM_B = [B_11, B_12; B_21, B_22];

ESM_C = [1 0; 0 1];

ESM_D = [0 0; 0 0];

%% Testumgebung öffnen
open_system('Testumgebung_Fahrzeugmodell.slx'); 

%% Simulation der Testumgebung
output = sim('Testumgebung_Fahrzeugmodell.slx');

